/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.tracing;

import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.openqa.selenium.remote.tracing.Span;

class OpenTracingSpan
implements Span {
    private final Tracer tracer;
    private final io.opentracing.Span span;

    OpenTracingSpan(Tracer tracer, io.opentracing.Span span) {
        this.tracer = Objects.requireNonNull(tracer, "Tracer must be set.");
        this.span = Objects.requireNonNull(span, "Span must be set.");
        this.activate();
    }

    @Override
    public Span activate() {
        this.tracer.scopeManager().activate(this.span, false);
        return this;
    }

    @Override
    public Span addTag(String key, Object value) {
        Objects.requireNonNull(key, "Key must be set");
        if (value == null) {
            return this;
        }
        this.span.setTag(key, String.valueOf(value));
        return this;
    }

    @Override
    public Span addTag(String key, boolean value) {
        Objects.requireNonNull(key, "Key must be set");
        this.span.setTag(key, value);
        return this;
    }

    @Override
    public Span addTag(String key, Number value) {
        Objects.requireNonNull(key, "Key must be set");
        this.span.setTag(key, value);
        return this;
    }

    @Override
    public void inject(final BiConsumer<String, String> forEachField) {
        TextMap maplike = new TextMap(){

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                throw new UnsupportedOperationException("iterator");
            }

            @Override
            public void put(String key, String value) {
                if (key != null && value != null) {
                    forEachField.accept(key, value);
                }
            }
        };
        this.tracer.inject(this.span.context(), Format.Builtin.HTTP_HEADERS, maplike);
    }

    @Override
    public void close() {
        this.span.finish();
    }

    SpanContext getContext() {
        return this.span.context();
    }

    public boolean equals(Object o) {
        if (!(o instanceof OpenTracingSpan)) {
            return false;
        }
        OpenTracingSpan that = (OpenTracingSpan)o;
        return Objects.equals(this.tracer, that.tracer) && Objects.equals(this.span, that.span);
    }

    public int hashCode() {
        return Objects.hash(this.tracer, this.span);
    }
}

