/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.tracing;

import io.opentracing.Tracer;
import io.opentracing.contrib.tracerresolver.TracerResolver;
import io.opentracing.noop.NoopTracerFactory;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.openqa.selenium.remote.tracing.OpenTracingTracer;
import org.openqa.selenium.remote.tracing.Span;

public interface DistributedTracer {
    public static Builder builder() {
        return new Builder();
    }

    public Span createSpan(String var1, Span var2);

    public <C> Span createSpan(String var1, C var2, Function<C, Map<String, String>> var3);

    public Span getActiveSpan();

    public static class Builder {
        private DistributedTracer tracer = new OpenTracingTracer(NoopTracerFactory.create());

        private Builder() {
        }

        public Builder use(Tracer openTracingTracer) {
            Objects.requireNonNull(openTracingTracer, "Tracer must be set.");
            this.tracer = new OpenTracingTracer(openTracingTracer);
            return this;
        }

        public Builder detect() {
            try {
                this.tracer = new OpenTracingTracer(TracerResolver.resolveTracer());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return this;
        }

        public DistributedTracer build() {
            return this.tracer;
        }
    }
}

