/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.rest;

import com.google.common.collect.Lists;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.RequiresAllSessions;
import org.openqa.selenium.remote.server.RequiresSession;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.DeleteSession;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;
import org.openqa.selenium.remote.server.log.LoggingManager;
import org.openqa.selenium.remote.server.log.PerSessionLogHandler;
import org.openqa.selenium.remote.server.rest.Responses;
import org.openqa.selenium.remote.server.rest.RestishHandler;

public class ResultConfig {
    private final String commandName;
    private final HandlerFactory handlerFactory;
    private final DriverSessions sessions;
    private final Logger log;

    public ResultConfig(String commandName, Supplier<RestishHandler<?>> factory, DriverSessions sessions, Logger log) {
        if (commandName == null || factory == null) {
            throw new IllegalArgumentException("You must specify the handler and the command name");
        }
        this.commandName = commandName;
        this.log = log;
        this.sessions = sessions;
        this.handlerFactory = sessionId -> (RestishHandler)factory.get();
    }

    public ResultConfig(String commandName, RequiresAllSessions factory, DriverSessions sessions, Logger log) {
        if (commandName == null || factory == null) {
            throw new IllegalArgumentException("You must specify the handler and the command name");
        }
        this.commandName = commandName;
        this.log = log;
        this.sessions = sessions;
        this.handlerFactory = sessionId -> (RestishHandler)factory.apply(sessions);
    }

    public ResultConfig(String commandName, RequiresSession factory, DriverSessions sessions, Logger log) {
        if (commandName == null || factory == null) {
            throw new IllegalArgumentException("You must specify the handler and the command name");
        }
        this.commandName = commandName;
        this.log = log;
        this.sessions = sessions;
        this.handlerFactory = sessionId -> (RestishHandler)factory.apply(sessions.get(sessionId));
    }

    public Response handle(Command command) {
        Response response = new Response();
        SessionId sessionId = command.getSessionId();
        if (sessionId != null) {
            response.setSessionId(sessionId.toString());
        }
        this.throwUpIfSessionTerminated(sessionId);
        RestishHandler<?> handler = this.handlerFactory.createHandler(sessionId);
        try {
            Map<String, Object> parameters = command.getParameters();
            if (parameters != null && !parameters.isEmpty()) {
                handler.setJsonParameters(parameters);
            }
            this.throwUpIfSessionTerminated(sessionId);
            Consumer<String> logger = "status".equals(command.getName()) ? this.log::fine : this.log::info;
            logger.accept(String.format("Executing: %s)", handler));
            Object value = handler.handle();
            if (value instanceof Response) {
                response = (Response)value;
            } else {
                response.setValue(value);
                response.setState("success");
                response.setStatus(0);
            }
            logger.accept("Done: " + handler);
        }
        catch (UnreachableBrowserException e) {
            this.throwUpIfSessionTerminated(sessionId);
            return Responses.failure(sessionId, e);
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Exception thrown", e);
            Throwable toUse = this.getRootExceptionCause(e);
            this.log.warning("Exception: " + toUse.getMessage());
            Optional<String> screenshot = Optional.empty();
            if (handler instanceof WebDriverHandler) {
                screenshot = Optional.ofNullable(((WebDriverHandler)handler).getScreenshot());
            }
            response = Responses.failure(sessionId, toUse, screenshot);
        }
        catch (Error e) {
            this.log.info("Error: " + e.getMessage());
            response = Responses.failure(sessionId, e);
        }
        if (handler instanceof DeleteSession) {
            PerSessionLogHandler logHandler = LoggingManager.perSessionLogHandler();
            logHandler.transferThreadTempLogsToSessionLogs(sessionId);
            logHandler.removeSessionLogs(sessionId);
        }
        return response;
    }

    private void throwUpIfSessionTerminated(SessionId sessId) throws NoSuchSessionException {
        boolean isTerminated;
        if (sessId == null) {
            return;
        }
        Session session = this.sessions.get(sessId);
        boolean bl = isTerminated = session == null;
        if (isTerminated) {
            throw new NoSuchSessionException();
        }
    }

    public Throwable getRootExceptionCause(Throwable originalException) {
        Throwable toReturn = originalException;
        if (originalException instanceof UndeclaredThrowableException) {
            toReturn = originalException.getCause().getCause();
        }
        ArrayList<Throwable> chain = new ArrayList<Throwable>(10);
        for (Throwable current = toReturn; current != null && chain.size() < 10; current = current.getCause()) {
            chain.add(current);
        }
        if (chain.isEmpty()) {
            return null;
        }
        ErrorCodes ec = new ErrorCodes();
        Iterator reversedChain = Lists.reverse(chain).iterator();
        Throwable rootCause = (Throwable)reversedChain.next();
        if (!reversedChain.hasNext() || ec.isMappableError(rootCause)) {
            return rootCause;
        }
        Throwable nextCause = (Throwable)reversedChain.next();
        return ec.isMappableError(nextCause) ? nextCause : rootCause;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResultConfig)) {
            return false;
        }
        ResultConfig that = (ResultConfig)o;
        return this.commandName.equals(that.commandName);
    }

    public int hashCode() {
        return this.commandName.hashCode();
    }

    static interface HandlerFactory {
        public RestishHandler<?> createHandler(SessionId var1);
    }
}

