/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.log;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.logging.SessionLogs;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.server.log.SessionLogsToFileRepository;

public class PerSessionLogHandler
extends Handler {
    private final Map<SessionId, List<LogRecord>> perSessionRecords;
    private final Map<SessionId, Map<String, LogEntries>> perSessionDriverEntries;
    private final Map<ThreadKey, List<LogRecord>> perThreadTempRecords;
    private final Formatter formatter;
    private Map<ThreadKey, SessionId> threadToSessionMap;
    private Map<SessionId, ThreadKey> sessionToThreadMap;
    private SessionLogsToFileRepository logFileRepository;
    private int capacity;
    private boolean storeLogsOnSessionQuit = false;
    private Level serverLogLevel = Level.INFO;

    public PerSessionLogHandler(int capacity, Formatter formatter, boolean captureLogsOnQuit) {
        this.capacity = capacity;
        this.formatter = formatter;
        this.storeLogsOnSessionQuit = captureLogsOnQuit;
        this.perSessionRecords = new HashMap<SessionId, List<LogRecord>>();
        this.perThreadTempRecords = new HashMap<ThreadKey, List<LogRecord>>();
        this.threadToSessionMap = new HashMap<ThreadKey, SessionId>();
        this.sessionToThreadMap = new HashMap<SessionId, ThreadKey>();
        this.logFileRepository = new SessionLogsToFileRepository();
        this.perSessionDriverEntries = new HashMap<SessionId, Map<String, LogEntries>>();
    }

    public synchronized void attachToCurrentThread(SessionId sessionId) {
        ThreadKey threadId = new ThreadKey();
        if (this.threadToSessionMap.get(threadId) == null || this.threadToSessionMap.get(threadId).equals(sessionId)) {
            this.threadToSessionMap.put(threadId, sessionId);
            this.sessionToThreadMap.put(sessionId, threadId);
        }
        this.transferThreadTempLogsToSessionLogs(sessionId);
    }

    public void transferThreadTempLogsToSessionLogs(SessionId sessionId) {
        ThreadKey threadId = new ThreadKey();
        List<LogRecord> threadRecords = this.perThreadTempRecords.get(threadId);
        List<LogRecord> sessionRecords = this.perSessionRecords.get(sessionId);
        if (threadRecords != null) {
            if (sessionRecords == null) {
                sessionRecords = new ArrayList<LogRecord>();
                this.perSessionRecords.put(sessionId, sessionRecords);
            }
            sessionRecords.addAll(threadRecords);
        }
        this.clearThreadTempLogs();
    }

    public synchronized void detachFromCurrentThread() {
        ThreadKey threadId = new ThreadKey();
        SessionId sessionId = this.threadToSessionMap.get(threadId);
        if (sessionId != null) {
            this.threadToSessionMap.remove(threadId);
            this.sessionToThreadMap.remove(sessionId);
            this.clearThreadTempLogs();
        }
    }

    public synchronized void removeSessionLogs(SessionId sessionId) {
        if (this.storeLogsOnSessionQuit) {
            return;
        }
        ThreadKey threadId = this.sessionToThreadMap.get(sessionId);
        SessionId sessionIdForThread = this.threadToSessionMap.get(threadId);
        if (threadId != null && sessionIdForThread != null && sessionIdForThread.equals(sessionId)) {
            this.threadToSessionMap.remove(threadId);
            this.sessionToThreadMap.remove(sessionId);
        }
        this.perSessionRecords.remove(sessionId);
        this.logFileRepository.removeLogFile(sessionId);
    }

    public synchronized void clearThreadTempLogs() {
        ThreadKey threadId = new ThreadKey();
        this.perThreadTempRecords.remove(threadId);
    }

    public synchronized String getLog(SessionId sessionId) throws IOException {
        String logs = this.formattedRecords(sessionId);
        logs = "\n<RC_Logs RC_Session_ID=" + sessionId + ">\n" + logs + "\n</RC_Logs>\n";
        return logs;
    }

    public synchronized List<SessionId> getLoggedSessions() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.addAll(this.perSessionDriverEntries.keySet());
        return builder.build();
    }

    public synchronized SessionLogs getAllLogsForSession(SessionId sessionId) {
        SessionLogs sessionLogs = new SessionLogs();
        if (this.perSessionDriverEntries.containsKey(sessionId)) {
            Map<String, LogEntries> typeToEntriesMap = this.perSessionDriverEntries.get(sessionId);
            for (String logType : typeToEntriesMap.keySet()) {
                sessionLogs.addLog(logType, typeToEntriesMap.get(logType));
            }
            this.perSessionDriverEntries.remove(sessionId);
        }
        return sessionLogs;
    }

    public synchronized LogEntries getSessionLog(SessionId sessionId) throws IOException {
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        for (LogRecord record : this.records(sessionId)) {
            if (record.getLevel().intValue() < this.serverLogLevel.intValue()) continue;
            entries.add(new LogEntry(record.getLevel(), record.getMillis(), record.getMessage()));
        }
        return new LogEntries(entries);
    }

    public synchronized void fetchAndStoreLogsFromDriver(SessionId sessionId, WebDriver driver) throws IOException {
        if (!this.perSessionDriverEntries.containsKey(sessionId)) {
            this.perSessionDriverEntries.put(sessionId, new HashMap());
        }
        Map<String, LogEntries> typeToEntriesMap = this.perSessionDriverEntries.get(sessionId);
        if (this.storeLogsOnSessionQuit) {
            typeToEntriesMap.put("server", this.getSessionLog(sessionId));
            Set<String> logTypeSet = driver.manage().logs().getAvailableLogTypes();
            for (String logType : logTypeSet) {
                typeToEntriesMap.put(logType, driver.manage().logs().get(logType));
            }
        }
    }

    public void configureLogging(LoggingPreferences prefs) {
        if (prefs == null) {
            return;
        }
        if (prefs.getEnabledLogTypes().contains("server")) {
            this.serverLogLevel = prefs.getLevel("server");
        }
    }

    @Override
    public synchronized void publish(LogRecord record) {
        ThreadKey threadId = new ThreadKey();
        SessionId sessionId = this.threadToSessionMap.get(threadId);
        if (sessionId != null) {
            List<LogRecord> records = this.perSessionRecords.get(sessionId);
            if (records == null) {
                records = new ArrayList<LogRecord>();
            }
            records.add(record);
            this.perSessionRecords.put(sessionId, records);
            if (records.size() > this.capacity) {
                this.perSessionRecords.put(sessionId, new ArrayList());
                try {
                    this.logFileRepository.flushRecordsToLogFile(sessionId, records);
                    records.clear();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            this.perThreadTempRecords.computeIfAbsent(threadId, k -> new ArrayList()).add(record);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public synchronized void close() throws SecurityException {
        this.perSessionRecords.clear();
        this.perThreadTempRecords.clear();
    }

    private LogRecord[] records(SessionId sessionId) throws IOException {
        List<LogRecord> logFileRecords = this.logFileRepository.getLogRecords(sessionId);
        List<LogRecord> records = this.perSessionRecords.remove(sessionId);
        if (records != null) {
            logFileRecords.addAll(records);
        }
        this.logFileRepository.removeLogFile(sessionId);
        return logFileRecords.toArray(new LogRecord[0]);
    }

    private String formattedRecords(SessionId sessionId) throws IOException {
        StringWriter writer = new StringWriter();
        for (LogRecord record : this.records(sessionId)) {
            writer.append(this.formatter.format(record));
        }
        return writer.toString();
    }

    protected static class ThreadKey {
        private final String name = Thread.currentThread().toString();
        private final Long id = Thread.currentThread().getId();

        ThreadKey() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ThreadKey threadKey = (ThreadKey)o;
            return Objects.equals(this.id, threadKey.id);
        }

        public int hashCode() {
            return this.id != null ? this.id.hashCode() : 0;
        }

        public String toString() {
            return "id" + this.id + "," + this.name;
        }
    }
}

