/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler.interactions;

import java.util.Map;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Coordinates;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.Locatable;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;

public class MouseMoveToLocation
extends WebDriverHandler<Void> {
    private static final String XOFFSET = "xoffset";
    private static final String YOFFSET = "yoffset";
    private static final String ELEMENT = "element";
    String elementId;
    boolean elementProvided = false;
    int xOffset = 0;
    int yOffset = 0;
    boolean offsetsProvided = false;

    public MouseMoveToLocation(Session session) {
        super(session);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        super.setJsonParameters(allParameters);
        if (allParameters.containsKey(ELEMENT) && allParameters.get(ELEMENT) != null) {
            this.elementId = (String)allParameters.get(ELEMENT);
            this.elementProvided = true;
        } else {
            this.elementProvided = false;
        }
        if (allParameters.containsKey(XOFFSET) && allParameters.containsKey(YOFFSET)) {
            try {
                this.xOffset = ((Number)allParameters.get(XOFFSET)).intValue();
            }
            catch (ClassCastException ex) {
                throw new WebDriverException("Illegal (non-numeric) x offset value for mouse move passed: " + allParameters.get(XOFFSET), ex);
            }
            try {
                this.yOffset = ((Number)allParameters.get(YOFFSET)).intValue();
            }
            catch (ClassCastException ex) {
                throw new WebDriverException("Illegal (non-numeric) y offset value for mouse move passed: " + allParameters.get(YOFFSET), ex);
            }
            this.offsetsProvided = true;
        } else {
            this.offsetsProvided = false;
        }
    }

    @Override
    public Void call() {
        Mouse mouse = ((HasInputDevices)((Object)this.getDriver())).getMouse();
        Coordinates elementLocation = null;
        if (this.elementProvided) {
            WebElement element = this.getKnownElements().get(this.elementId);
            elementLocation = ((Locatable)((Object)element)).getCoordinates();
        }
        if (this.offsetsProvided) {
            mouse.mouseMove(elementLocation, this.xOffset, this.yOffset);
        } else {
            mouse.mouseMove(elementLocation);
        }
        return null;
    }

    public String toString() {
        return String.format("[mousemove: %s %b]", this.elementId, this.offsetsProvided);
    }
}

