/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import org.openqa.selenium.grid.session.ActiveSession;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.grid.web.NoHandler;
import org.openqa.selenium.grid.web.UrlTemplate;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.server.ActiveSessions;
import org.openqa.selenium.remote.server.NewSessionPipeline;
import org.openqa.selenium.remote.server.commandhandler.BeginSession;
import org.openqa.selenium.remote.server.commandhandler.GetAllSessions;
import org.openqa.selenium.remote.server.commandhandler.GetLogTypes;
import org.openqa.selenium.remote.server.commandhandler.GetLogsOfType;
import org.openqa.selenium.remote.server.commandhandler.NoSessionHandler;
import org.openqa.selenium.remote.server.commandhandler.Status;
import org.openqa.selenium.remote.server.commandhandler.UploadFile;

class AllHandlers {
    private final Json json;
    private final ActiveSessions allSessions;
    private final Map<HttpMethod, ImmutableList<Function<String, CommandHandler>>> additionalHandlers;

    public AllHandlers(NewSessionPipeline pipeline, ActiveSessions allSessions) {
        this.allSessions = Objects.requireNonNull(allSessions);
        this.json = new Json();
        this.additionalHandlers = ImmutableMap.of(HttpMethod.DELETE, ImmutableList.of(), HttpMethod.GET, ImmutableList.of(this.handler("/session/{sessionId}/log/types", params -> new GetLogTypes(this.json, allSessions.get(new SessionId((String)params.get("sessionId"))))), this.handler("/sessions", params -> new GetAllSessions(allSessions, this.json)), this.handler("/status", params -> new Status(this.json))), HttpMethod.POST, ImmutableList.of(this.handler("/session", params -> new BeginSession(pipeline, allSessions, this.json)), this.handler("/session/{sessionId}/file", params -> new UploadFile(this.json, allSessions.get(new SessionId((String)params.get("sessionId"))))), this.handler("/session/{sessionId}/log", params -> new GetLogsOfType(this.json, allSessions.get(new SessionId((String)params.get("sessionId"))))), this.handler("/session/{sessionId}/se/file", params -> new UploadFile(this.json, allSessions.get(new SessionId((String)params.get("sessionId")))))));
    }

    public CommandHandler match(HttpServletRequest req) {
        String path = Strings.isNullOrEmpty(req.getPathInfo()) ? "/" : req.getPathInfo();
        Optional<CommandHandler> additionalHandler = this.additionalHandlers.get((Object)HttpMethod.valueOf(req.getMethod())).stream().map(bundle -> (CommandHandler)bundle.apply(req.getPathInfo())).filter(Objects::nonNull).findFirst();
        if (additionalHandler.isPresent()) {
            return additionalHandler.get();
        }
        SessionId id = null;
        List<String> fragments = Splitter.on('/').limit(4).splitToList(path);
        if (fragments.size() > 2 && "session".equals(fragments.get(1))) {
            id = new SessionId(fragments.get(2));
        }
        if (id != null) {
            ActiveSession session = this.allSessions.get(id);
            if (session == null) {
                return new NoSessionHandler(this.json, id);
            }
            return session;
        }
        return new NoHandler(this.json);
    }

    private <H extends CommandHandler> Function<String, CommandHandler> handler(String template, Function<Map<String, String>, H> handlerGenerator) {
        UrlTemplate urlTemplate = new UrlTemplate(template);
        return path -> {
            UrlTemplate.Match match = urlTemplate.match((String)path);
            if (match == null) {
                return null;
            }
            return (CommandHandler)handlerGenerator.apply(match.getParameters());
        };
    }
}

