/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.internal;

import java.io.UncheckedIOException;
import java.util.Objects;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.openqa.selenium.remote.http.WebSocket;

class OkHttpWebSocket
implements org.openqa.selenium.remote.http.WebSocket {
    private final WebSocket socket;

    OkHttpWebSocket(OkHttpClient client, Request request, final WebSocket.Listener listener) {
        Objects.requireNonNull(client, "HTTP client to use must be set.");
        Objects.requireNonNull(request, "Request to send must be set.");
        Objects.requireNonNull(listener, "WebSocket listener must be set.");
        this.socket = client.newWebSocket(request, new WebSocketListener(){

            @Override
            public void onMessage(WebSocket webSocket, String text) {
                if (text != null) {
                    listener.onText(text);
                }
            }

            @Override
            public void onClosed(WebSocket webSocket, int code, String reason) {
                listener.onClose(code, reason);
            }

            @Override
            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                listener.onError(t);
            }
        });
    }

    @Override
    public org.openqa.selenium.remote.http.WebSocket sendText(CharSequence data) {
        this.socket.send(data.toString());
        return this;
    }

    @Override
    public void close() throws UncheckedIOException {
        this.socket.close(1000, "WebDriver closing socket");
    }

    @Override
    public void abort() {
        this.socket.cancel();
    }
}

