/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Iterator;
import java.util.Objects;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;

public class HttpRequest
extends HttpMessage {
    private final HttpMethod method;
    private final String uri;
    private final Multimap<String, String> queryParameters = ArrayListMultimap.create();

    public HttpRequest(HttpMethod method, String uri) {
        this.method = method;
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getQueryParameter(String name) {
        Iterable<String> allParams = this.getQueryParameters(name);
        if (allParams == null) {
            return null;
        }
        Iterator<String> iterator = allParams.iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    public HttpRequest addQueryParameter(String name, String value) {
        this.queryParameters.put(Objects.requireNonNull(name, "Name must be set"), Objects.requireNonNull(value, "Value must be set"));
        return this;
    }

    public Iterable<String> getQueryParameterNames() {
        return this.queryParameters.keySet();
    }

    public Iterable<String> getQueryParameters(String name) {
        return this.queryParameters.get(name);
    }

    public String toString() {
        return "(" + (Object)((Object)this.getMethod()) + ") " + this.getUri();
    }
}

