/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.time.Duration;
import java.util.Locale;
import java.util.Objects;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.WebSocket;

public interface HttpClient {
    public static final String USER_AGENT = String.format("selenium/%s (java %s)", new BuildInfo().getReleaseLabel(), Platform.getCurrent().family() == null ? Platform.getCurrent().toString().toLowerCase(Locale.US) : Platform.getCurrent().family().toString().toLowerCase(Locale.US));

    public HttpResponse execute(HttpRequest var1) throws IOException;

    public WebSocket openSocket(HttpRequest var1, WebSocket.Listener var2);

    public static abstract class Builder {
        protected Duration connectionTimeout = Duration.ofMinutes(2L);
        protected Duration readTimeout = Duration.ofHours(3L);
        protected Proxy proxy = null;

        public Builder connectionTimeout(Duration duration) {
            Objects.requireNonNull(duration, "Connection time out must be set");
            Preconditions.checkArgument(!duration.isNegative(), "Connection time out cannot be negative");
            this.connectionTimeout = duration;
            return this;
        }

        public Builder readTimeout(Duration duration) {
            Objects.requireNonNull(duration, "Read time out must be set");
            Preconditions.checkArgument(!duration.isNegative(), "Read time out cannot be negative");
            this.readTimeout = duration;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = Objects.requireNonNull(proxy, "Proxy must be set");
            return this;
        }

        public abstract HttpClient createClient(URL var1);
    }

    public static interface Factory {
        public static Factory createDefault() {
            String defaultFactory;
            switch (defaultFactory = System.getProperty("webdriver.http.factory", "okhttp")) {
                default: 
            }
            try {
                Class<Factory> clazz = Class.forName("org.openqa.selenium.remote.internal.OkHttpClient$Factory").asSubclass(Factory.class);
                return clazz.newInstance();
            }
            catch (ReflectiveOperationException e) {
                throw new UnsupportedOperationException("Unable to create HTTP client factory", e);
            }
        }

        public Builder builder();

        default public HttpClient createClient(URL url) {
            return this.builder().createClient(url);
        }

        public void cleanupIdleClients();
    }
}

