/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.logging.LocalLogs;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.logging.NeedsLocalLogs;
import org.openqa.selenium.logging.profiler.HttpProfilerLogEntry;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandCodec;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.HttpSessionId;
import org.openqa.selenium.remote.ProtocolHandshake;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.ResponseCodec;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class HttpCommandExecutor
implements CommandExecutor,
NeedsLocalLogs {
    private static final HttpClient.Factory defaultClientFactory = HttpClient.Factory.createDefault();
    private final URL remoteServer;
    private final HttpClient client;
    private final HttpClient.Factory httpClientFactory;
    private final Map<String, CommandInfo> additionalCommands;
    private CommandCodec<HttpRequest> commandCodec;
    private ResponseCodec<HttpResponse> responseCodec;
    private LocalLogs logs = LocalLogs.getNullLogger();

    public HttpCommandExecutor(URL addressOfRemoteServer) {
        this(ImmutableMap.of(), addressOfRemoteServer);
    }

    public HttpCommandExecutor(Map<String, CommandInfo> additionalCommands, URL addressOfRemoteServer) {
        this(additionalCommands, addressOfRemoteServer, defaultClientFactory);
    }

    public HttpCommandExecutor(Map<String, CommandInfo> additionalCommands, URL addressOfRemoteServer, HttpClient.Factory httpClientFactory) {
        try {
            this.remoteServer = addressOfRemoteServer == null ? new URL(System.getProperty("webdriver.remote.server", "http://localhost:4444/wd/hub")) : addressOfRemoteServer;
        }
        catch (MalformedURLException e) {
            throw new WebDriverException(e);
        }
        this.additionalCommands = additionalCommands;
        this.httpClientFactory = httpClientFactory;
        this.client = httpClientFactory.createClient(this.remoteServer);
    }

    protected void defineCommand(String commandName, CommandInfo info) {
        Preconditions.checkNotNull(commandName);
        Preconditions.checkNotNull(info);
        this.commandCodec.defineCommand(commandName, info.getMethod(), info.getUrl());
    }

    @Override
    public void setLocalLogs(LocalLogs logs) {
        this.logs = logs;
    }

    private void log(String logType, LogEntry entry) {
        this.logs.addEntry(logType, entry);
    }

    public URL getAddressOfRemoteServer() {
        return this.remoteServer;
    }

    @Override
    public Response execute(Command command) throws IOException {
        if (command.getSessionId() == null) {
            if ("quit".equals(command.getName())) {
                return new Response();
            }
            if (!"getAllSessions".equals(command.getName()) && !"newSession".equals(command.getName())) {
                throw new NoSuchSessionException("Session ID is null. Using WebDriver after calling quit()?");
            }
        }
        if ("newSession".equals(command.getName())) {
            if (this.commandCodec != null) {
                throw new SessionNotCreatedException("Session already exists");
            }
            ProtocolHandshake handshake = new ProtocolHandshake();
            this.log("profiler", new HttpProfilerLogEntry(command.getName(), true));
            ProtocolHandshake.Result result = handshake.createSession(this.client, command);
            Dialect dialect = result.getDialect();
            this.commandCodec = dialect.getCommandCodec();
            for (Map.Entry<String, CommandInfo> entry : this.additionalCommands.entrySet()) {
                this.defineCommand(entry.getKey(), entry.getValue());
            }
            this.responseCodec = dialect.getResponseCodec();
            this.log("profiler", new HttpProfilerLogEntry(command.getName(), false));
            return result.createResponse();
        }
        if (this.commandCodec == null || this.responseCodec == null) {
            throw new WebDriverException("No command or response codec has been defined. Unable to proceed");
        }
        HttpRequest httpRequest = this.commandCodec.encode(command);
        try {
            this.log("profiler", new HttpProfilerLogEntry(command.getName(), true));
            HttpResponse httpResponse = this.client.execute(httpRequest);
            this.log("profiler", new HttpProfilerLogEntry(command.getName(), false));
            Response response = this.responseCodec.decode(httpResponse);
            if (response.getSessionId() == null) {
                if (httpResponse.getTargetHost() != null) {
                    response.setSessionId(HttpSessionId.getSessionId(httpResponse.getTargetHost()).orElse(null));
                } else {
                    response.setSessionId(command.getSessionId().toString());
                }
            }
            if ("quit".equals(command.getName())) {
                this.httpClientFactory.cleanupIdleClients();
            }
            return response;
        }
        catch (UnsupportedCommandException e) {
            if (e.getMessage() == null || "".equals(e.getMessage())) {
                throw new UnsupportedOperationException("No information from server. Command name was: " + command.getName(), e.getCause());
            }
            throw e;
        }
    }
}

