/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Platform;

public class DesiredCapabilities
extends MutableCapabilities {
    private static final Logger LOG = Logger.getLogger(Capabilities.class.getName());

    public DesiredCapabilities(String browser, String version, Platform platform) {
        this.setCapability("browserName", browser);
        this.setCapability("version", version);
        this.setCapability("platform", platform);
    }

    public DesiredCapabilities() {
    }

    public DesiredCapabilities(Map<String, ?> rawMap) {
        if (rawMap == null) {
            return;
        }
        rawMap.forEach(this::setCapability);
    }

    public DesiredCapabilities(Capabilities other) {
        this.merge(other);
    }

    public DesiredCapabilities(Capabilities ... others) {
        for (Capabilities caps : others) {
            this.merge(caps);
        }
    }

    public void setBrowserName(String browserName) {
        this.setCapability("browserName", browserName);
    }

    public void setVersion(String version) {
        this.setCapability("version", version);
    }

    public void setPlatform(Platform platform) {
        this.setCapability("platform", platform);
    }

    public void setJavascriptEnabled(boolean javascriptEnabled) {
        this.setCapability("javascriptEnabled", javascriptEnabled);
    }

    public boolean acceptInsecureCerts() {
        if (this.getCapability("acceptInsecureCerts") != null) {
            Object raw = this.getCapability("acceptInsecureCerts");
            if (raw instanceof String) {
                return Boolean.parseBoolean((String)raw);
            }
            if (raw instanceof Boolean) {
                return (Boolean)raw;
            }
        }
        return true;
    }

    public void setAcceptInsecureCerts(boolean acceptInsecureCerts) {
        this.setCapability("acceptInsecureCerts", acceptInsecureCerts);
    }

    @Override
    public DesiredCapabilities merge(Capabilities extraCapabilities) {
        super.merge(extraCapabilities);
        return this;
    }

    @Deprecated
    @VisibleForTesting
    public static DesiredCapabilities htmlUnit() {
        return new DesiredCapabilities("htmlunit", "", Platform.ANY);
    }
}

