/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.net;

import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.internal.HostIdentifier;
import org.openqa.selenium.net.NetworkInterface;
import org.openqa.selenium.net.NetworkInterfaceProvider;

public class DefaultNetworkInterfaceProvider
implements NetworkInterfaceProvider {
    private final List<NetworkInterface> cachedInterfaces;

    @Override
    public Iterable<NetworkInterface> getNetworkInterfaces() {
        return this.cachedInterfaces;
    }

    public DefaultNetworkInterfaceProvider() {
        Enumeration<java.net.NetworkInterface> interfaces = null;
        try {
            interfaces = java.net.NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new WebDriverException(e);
        }
        InetAddress defaultAddress = null;
        if (!"Unknown".equals(HostIdentifier.getHostAddress())) {
            try {
                defaultAddress = InetAddress.getByName(HostIdentifier.getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        ArrayList<NetworkInterface> result = new ArrayList<NetworkInterface>();
        boolean defaultFound = false;
        while (interfaces.hasMoreElements()) {
            java.net.NetworkInterface jvmNic = interfaces.nextElement();
            NetworkInterface nic = new NetworkInterface(jvmNic);
            result.add(nic);
            if (defaultAddress == null || defaultFound) continue;
            Enumeration<InetAddress> inetAddresses = jvmNic.getInetAddresses();
            while (inetAddresses.hasMoreElements() && !defaultFound) {
                InetAddress address = inetAddresses.nextElement();
                if (!defaultAddress.equals(address)) continue;
                result.add(0, nic);
                defaultFound = true;
            }
        }
        this.cachedInterfaces = Collections.unmodifiableList(result);
    }

    private String getLocalInterfaceName() {
        if (Platform.getCurrent().is(Platform.MAC)) {
            return "lo0";
        }
        return "lo";
    }

    @Override
    public NetworkInterface getLoInterface() {
        String localIF = this.getLocalInterfaceName();
        try {
            java.net.NetworkInterface byName = java.net.NetworkInterface.getByName(localIF);
            return byName != null ? new NetworkInterface(byName) : null;
        }
        catch (SocketException e) {
            throw new WebDriverException(e);
        }
    }
}

