/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.ie;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Streams;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.Beta;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ie.ElementScrollBehavior;
import org.openqa.selenium.remote.AbstractDriverOptions;

@Beta
public class InternetExplorerOptions
extends AbstractDriverOptions<InternetExplorerOptions> {
    static final String IE_OPTIONS = "se:ieOptions";
    private static final String FULL_PAGE_SCREENSHOT = "ie.enableFullPageScreenshot";
    private static final String UPLOAD_DIALOG_TIMEOUT = "ie.fileUploadDialogTimeout";
    private static final String FORCE_WINDOW_SHELL_API = "ie.forceShellWindowsApi";
    private static final String VALIDATE_COOKIE_DOCUMENT_TYPE = "ie.validateCookieDocumentType";
    private static final Set<String> CAPABILITY_NAMES = ((ImmutableSortedSet.Builder)((ImmutableSortedSet.Builder)((ImmutableSortedSet.Builder)((ImmutableSortedSet.Builder)((ImmutableSortedSet.Builder)((ImmutableSortedSet.Builder)((ImmutableSortedSet.Builder)((ImmutableSortedSet.Builder)((ImmutableSortedSet.Builder)((ImmutableSortedSet.Builder)((ImmutableSortedSet.Builder)((ImmutableSortedSet.Builder)((ImmutableSortedSet.Builder)((ImmutableSortedSet.Builder)((ImmutableSortedSet.Builder)((ImmutableSortedSet.Builder)ImmutableSortedSet.naturalOrder().add("browserAttachTimeout")).add("elementScrollBehavior")).add("enablePersistentHover")).add("ie.enableFullPageScreenshot")).add("ie.forceCreateProcessApi")).add("ie.forceShellWindowsApi")).add("ie.ensureCleanSession")).add("ie.browserCommandLineSwitches")).add("ie.usePerProcessProxy")).add("ignoreZoomSetting")).add("initialBrowserUrl")).add("ignoreProtectedModeSettings")).add("requireWindowFocus")).add("ie.fileUploadDialogTimeout")).add("ie.validateCookieDocumentType")).add("nativeEvents")).build();
    private Map<String, Object> ieOptions = new HashMap<String, Object>();

    public InternetExplorerOptions() {
        this.setCapability("browserName", "internet explorer");
        this.setCapability(IE_OPTIONS, this.ieOptions);
    }

    public InternetExplorerOptions(Capabilities source) {
        this();
        this.merge(source);
    }

    @Override
    public InternetExplorerOptions merge(Capabilities extraCapabilities) {
        super.merge(extraCapabilities);
        return this;
    }

    public InternetExplorerOptions withAttachTimeout(long duration, TimeUnit unit) {
        return this.withAttachTimeout(Duration.ofMillis(unit.toMillis(duration)));
    }

    public InternetExplorerOptions withAttachTimeout(Duration duration) {
        return this.amend("browserAttachTimeout", duration.toMillis());
    }

    public InternetExplorerOptions elementScrollTo(ElementScrollBehavior behavior) {
        return this.amend("elementScrollBehavior", behavior.getValue());
    }

    public InternetExplorerOptions enablePersistentHovering() {
        return this.amend("enablePersistentHover", true);
    }

    public InternetExplorerOptions useCreateProcessApiToLaunchIe() {
        return this.amend("ie.forceCreateProcessApi", true);
    }

    public InternetExplorerOptions useShellWindowsApiToAttachToIe() {
        return this.amend(FORCE_WINDOW_SHELL_API, true);
    }

    public InternetExplorerOptions destructivelyEnsureCleanSession() {
        return this.amend("ie.ensureCleanSession", true);
    }

    public InternetExplorerOptions addCommandSwitches(String ... switches) {
        List<Object> raw = this.getCapability("ie.browserCommandLineSwitches");
        if (raw == null) {
            raw = new LinkedList();
        } else if (raw instanceof String) {
            raw = Arrays.asList(((String)((Object)raw)).split(" "));
        }
        return this.amend("ie.browserCommandLineSwitches", Streams.concat(((List)List.class.cast(raw)).stream(), Stream.of(switches)).filter(i -> i instanceof String).map(String.class::cast).collect(ImmutableList.toImmutableList()));
    }

    public InternetExplorerOptions usePerProcessProxy() {
        return this.amend("ie.usePerProcessProxy", true);
    }

    public InternetExplorerOptions withInitialBrowserUrl(String url) {
        return this.amend("initialBrowserUrl", Preconditions.checkNotNull(url));
    }

    public InternetExplorerOptions requireWindowFocus() {
        return this.amend("requireWindowFocus", true);
    }

    public InternetExplorerOptions waitForUploadDialogUpTo(long duration, TimeUnit unit) {
        return this.waitForUploadDialogUpTo(Duration.ofMillis(unit.toMillis(duration)));
    }

    public InternetExplorerOptions waitForUploadDialogUpTo(Duration duration) {
        return this.amend(UPLOAD_DIALOG_TIMEOUT, duration.toMillis());
    }

    public InternetExplorerOptions introduceFlakinessByIgnoringSecurityDomains() {
        return this.amend("ignoreProtectedModeSettings", true);
    }

    public InternetExplorerOptions disableNativeEvents() {
        return this.amend("nativeEvents", false);
    }

    public InternetExplorerOptions ignoreZoomSettings() {
        return this.amend("ignoreZoomSetting", true);
    }

    public InternetExplorerOptions takeFullPageScreenshot() {
        return this.amend(FULL_PAGE_SCREENSHOT, true);
    }

    private InternetExplorerOptions amend(String optionName, Object value) {
        this.setCapability(optionName, value);
        return this;
    }

    @Override
    public void setCapability(String key, Object value) {
        super.setCapability(key, value);
        if ("ie.browserCommandLineSwitches".equals(key) && value instanceof List) {
            value = ((List)value).stream().map(Object::toString).collect(Collectors.joining(" "));
        }
        if (CAPABILITY_NAMES.contains(key)) {
            this.ieOptions.put(key, value);
        }
        if (IE_OPTIONS.equals(key)) {
            Map<String, Object> streamFrom;
            this.ieOptions.clear();
            if (value instanceof Map) {
                streamFrom = (Map<String, Object>)value;
            } else if (value instanceof Capabilities) {
                streamFrom = ((Capabilities)value).asMap();
            } else {
                throw new IllegalArgumentException("Value must not be null for " + key);
            }
            streamFrom.entrySet().stream().filter(e -> CAPABILITY_NAMES.contains(e.getKey())).filter(e -> e.getValue() != null).forEach(e -> {
                if ("ie.browserCommandLineSwitches".equals(e.getKey())) {
                    this.setCapability((String)e.getKey(), Arrays.asList(((String)e.getValue()).split(" ")));
                } else {
                    this.setCapability((String)e.getKey(), e.getValue());
                }
            });
        }
    }
}

