/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandCodec;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.ResponseCodec;
import org.openqa.selenium.remote.codec.jwp.JsonHttpCommandCodec;
import org.openqa.selenium.remote.codec.jwp.JsonHttpResponseCodec;
import org.openqa.selenium.remote.codec.w3c.W3CHttpCommandCodec;
import org.openqa.selenium.remote.codec.w3c.W3CHttpResponseCodec;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.internal.JsonToWebElementConverter;

public class ProtocolConverter
implements CommandHandler {
    private static final ImmutableSet<String> IGNORED_REQ_HEADERS = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add("connection")).add("keep-alive")).add("proxy-authorization")).add("proxy-authenticate")).add("proxy-connection")).add("te")).add("trailer")).add("transfer-encoding")).add("upgrade")).build();
    private final HttpClient client;
    private final CommandCodec<HttpRequest> downstream;
    private final CommandCodec<HttpRequest> upstream;
    private final ResponseCodec<HttpResponse> downstreamResponse;
    private final ResponseCodec<HttpResponse> upstreamResponse;
    private final JsonToWebElementConverter converter;

    public ProtocolConverter(HttpClient client, Dialect downstream, Dialect upstream) {
        this.client = Objects.requireNonNull(client);
        Objects.requireNonNull(downstream);
        this.downstream = this.getCommandCodec(downstream);
        this.downstreamResponse = this.getResponseCodec(downstream);
        Objects.requireNonNull(upstream);
        this.upstream = this.getCommandCodec(upstream);
        this.upstreamResponse = this.getResponseCodec(upstream);
        this.converter = new JsonToWebElementConverter(null);
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) throws IOException {
        Command command = this.downstream.decode(req);
        Map parameters = (Map)this.converter.apply(command.getParameters());
        command = new Command(command.getSessionId(), command.getName(), parameters);
        HttpRequest request = this.upstream.encode(command);
        HttpResponse res = this.makeRequest(request);
        Response decoded = this.upstreamResponse.decode(res);
        HttpResponse response = this.downstreamResponse.encode(HttpResponse::new, decoded);
        this.copyToServletResponse(response, resp);
    }

    @VisibleForTesting
    HttpResponse makeRequest(HttpRequest request) throws IOException {
        return this.client.execute(request);
    }

    private void copyToServletResponse(HttpResponse response, HttpResponse resp) {
        resp.setStatus(response.getStatus());
        for (String name : response.getHeaderNames()) {
            if (IGNORED_REQ_HEADERS.contains(name.toLowerCase())) continue;
            for (String value : response.getHeaders(name)) {
                resp.addHeader(name, value);
            }
        }
        resp.setContent(response.consumeContentStream());
    }

    private CommandCodec<HttpRequest> getCommandCodec(Dialect dialect) {
        switch (dialect) {
            case OSS: {
                return new JsonHttpCommandCodec();
            }
            case W3C: {
                return new W3CHttpCommandCodec();
            }
        }
        throw new IllegalStateException("Unknown dialect: " + (Object)((Object)dialect));
    }

    private ResponseCodec<HttpResponse> getResponseCodec(Dialect dialect) {
        switch (dialect) {
            case OSS: {
                return new JsonHttpResponseCodec();
            }
            case W3C: {
                return new W3CHttpResponseCodec();
            }
        }
        throw new IllegalStateException("Unknown dialect: " + (Object)((Object)dialect));
    }
}

