/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.server;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;

public class ServletRequestWrappingHttpRequest
extends HttpRequest {
    private final HttpServletRequest req;

    public ServletRequestWrappingHttpRequest(HttpServletRequest req) {
        super(HttpMethod.valueOf(req.getMethod()), req.getPathInfo() == null ? "/" : req.getPathInfo());
        this.req = req;
    }

    @Override
    public Iterable<String> getHeaderNames() {
        return Collections.list(this.req.getHeaderNames());
    }

    @Override
    public Iterable<String> getHeaders(String name) {
        return Collections.list(this.req.getHeaders(name));
    }

    @Override
    public String getHeader(String name) {
        return this.req.getHeader(name);
    }

    @Override
    public void removeHeader(String name) {
        throw new UnsupportedOperationException("removeHeader");
    }

    @Override
    public void setHeader(String name, String value) {
        throw new UnsupportedOperationException("setHeader");
    }

    @Override
    public void addHeader(String name, String value) {
        throw new UnsupportedOperationException("addHeader");
    }

    @Override
    public HttpRequest addQueryParameter(String name, String value) {
        throw new UnsupportedOperationException("addQueryParameter");
    }

    @Override
    public Iterable<String> getQueryParameterNames() {
        return this.parseQueryString().keySet();
    }

    private Map<String, Collection<String>> parseQueryString() {
        String queryString = this.req.getQueryString();
        if (queryString == null || queryString.isEmpty()) {
            return ImmutableMap.of();
        }
        ImmutableMultimap.Builder<String, String> allParams = ImmutableMultimap.builder();
        Iterable<String> paramsAndValues = Splitter.on("&").split(queryString);
        for (String paramAndValue : paramsAndValues) {
            String value;
            String key;
            int index = paramAndValue.indexOf("=");
            if (index == -1) {
                key = paramAndValue;
                value = "";
            } else {
                key = paramAndValue.substring(0, index);
                value = paramAndValue.length() >= index ? paramAndValue.substring(index + 1) : "";
            }
            try {
                allParams.put(URLDecoder.decode(key, "UTF-8"), URLDecoder.decode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return allParams.build().asMap();
    }

    @Override
    public Iterable<String> getQueryParameters(String name) {
        return this.parseQueryString().getOrDefault(name, ImmutableSet.of());
    }

    @Override
    public void setContent(byte[] data) {
        throw new UnsupportedOperationException("setContent");
    }

    @Override
    public void setContent(InputStream toStreamFrom) {
        throw new UnsupportedOperationException("setContent");
    }

    @Override
    public InputStream consumeContentStream() {
        try {
            return this.req.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

