/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.server;

import com.google.common.collect.ImmutableMap;
import com.google.common.net.MediaType;
import java.io.UncheckedIOException;
import java.net.BindException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.grid.server.BaseServerOptions;
import org.openqa.selenium.grid.server.CommandHandlerServlet;
import org.openqa.selenium.grid.server.Server;
import org.openqa.selenium.grid.server.W3CCommandHandler;
import org.openqa.selenium.grid.web.CombinedRoute;
import org.openqa.selenium.grid.web.Routes;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.net.NetworkUtils;
import org.openqa.selenium.net.PortProber;
import org.seleniumhq.jetty9.security.ConstraintMapping;
import org.seleniumhq.jetty9.security.ConstraintSecurityHandler;
import org.seleniumhq.jetty9.server.Connector;
import org.seleniumhq.jetty9.server.HttpConfiguration;
import org.seleniumhq.jetty9.server.HttpConnectionFactory;
import org.seleniumhq.jetty9.server.ServerConnector;
import org.seleniumhq.jetty9.servlet.ServletContextHandler;
import org.seleniumhq.jetty9.servlet.ServletHolder;
import org.seleniumhq.jetty9.util.log.JavaUtilLog;
import org.seleniumhq.jetty9.util.log.Log;
import org.seleniumhq.jetty9.util.security.Constraint;
import org.seleniumhq.jetty9.util.thread.QueuedThreadPool;

public class BaseServer<T extends BaseServer>
implements Server<T> {
    private static final Logger LOG = Logger.getLogger(BaseServer.class.getName());
    private static final int MAX_SHUTDOWN_RETRIES = 8;
    private final org.seleniumhq.jetty9.server.Server server;
    private final List<Routes> routes = new ArrayList<Routes>();
    private final ServletContextHandler servletContextHandler;
    private final URL url;

    public BaseServer(BaseServerOptions options) {
        int port = options.getPort() == 0 ? PortProber.findFreePort() : options.getPort();
        String host = options.getHostname().orElseGet(() -> {
            try {
                return new NetworkUtils().getNonLoopbackAddressOfThisMachine();
            }
            catch (WebDriverException ignored) {
                return "localhost";
            }
        });
        try {
            this.url = new URL("http", host, port, "");
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
        Log.setLog(new JavaUtilLog());
        this.server = new org.seleniumhq.jetty9.server.Server(new QueuedThreadPool(options.getMaxServerThreads()));
        Json json = new Json();
        this.addRoute(Routes.get("/status").using((in, out) -> {
            String value = json.toJson(ImmutableMap.of("value", ImmutableMap.of("ready", false, "message", "Stub server without handlers")));
            out.setHeader("Content-Type", MediaType.JSON_UTF_8.toString());
            out.setHeader("Cache-Control", "none");
            out.setStatus(200);
            out.setContent(value.getBytes(StandardCharsets.UTF_8));
        }).build());
        this.servletContextHandler = new ServletContextHandler(2);
        ConstraintSecurityHandler securityHandler = (ConstraintSecurityHandler)this.servletContextHandler.getSecurityHandler();
        Constraint disableTrace = new Constraint();
        disableTrace.setName("Disable TRACE");
        disableTrace.setAuthenticate(true);
        ConstraintMapping disableTraceMapping = new ConstraintMapping();
        disableTraceMapping.setConstraint(disableTrace);
        disableTraceMapping.setMethod("TRACE");
        disableTraceMapping.setPathSpec("/");
        securityHandler.addConstraintMapping(disableTraceMapping);
        Constraint enableOther = new Constraint();
        enableOther.setName("Enable everything but TRACE");
        ConstraintMapping enableOtherMapping = new ConstraintMapping();
        enableOtherMapping.setConstraint(enableOther);
        enableOtherMapping.setMethodOmissions(new String[]{"TRACE"});
        enableOtherMapping.setPathSpec("/");
        securityHandler.addConstraintMapping(enableOtherMapping);
        this.server.setHandler(this.servletContextHandler);
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecureScheme("https");
        ServerConnector http = new ServerConnector(this.server, new HttpConnectionFactory(httpConfig));
        options.getHostname().ifPresent(http::setHost);
        http.setPort(this.getUrl().getPort());
        http.setIdleTimeout(500000L);
        this.server.setConnectors(new Connector[]{http});
    }

    @Override
    public void addServlet(Class<? extends Servlet> servlet, String pathSpec) {
        if (this.server.isRunning()) {
            throw new IllegalStateException("You may not add a servlet to a running server");
        }
        this.servletContextHandler.addServlet(Objects.requireNonNull(servlet), Objects.requireNonNull(pathSpec));
    }

    @Override
    public void addServlet(Servlet servlet, String pathSpec) {
        if (this.server.isRunning()) {
            throw new IllegalStateException("You may not add a servlet to a running server");
        }
        this.servletContextHandler.addServlet(new ServletHolder(Objects.requireNonNull(servlet)), Objects.requireNonNull(pathSpec));
    }

    @Override
    public void addRoute(Routes route) {
        if (this.server.isRunning()) {
            throw new IllegalStateException("You may not add a handler to a running server");
        }
        this.routes.add(route);
    }

    @Override
    public boolean isStarted() {
        return this.server.isStarted();
    }

    @Override
    public T start() {
        try {
            if (this.routes.isEmpty()) {
                throw new IllegalStateException("There must be at least one route specified");
            }
            Routes first = this.routes.remove(0);
            Routes routes = ((CombinedRoute)Routes.combine(first, this.routes.toArray(new Routes[0])).decorateWith(W3CCommandHandler::new)).build();
            this.addServlet(new CommandHandlerServlet(routes), "/*");
            this.server.start();
            PortProber.waitForPortUp(this.getUrl().getPort(), 10, TimeUnit.SECONDS);
            return (T)this;
        }
        catch (Exception e) {
            try {
                this.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof BindException) {
                LOG.severe(String.format("Port %s is busy, please choose a free port and specify it using -port option", this.getUrl().getPort()));
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void stop() {
        Exception shutDownException = null;
        for (int numTries = 0; numTries <= 8; ++numTries) {
            try {
                this.server.stop();
                return;
            }
            catch (Exception ex) {
                shutDownException = ex;
                continue;
            }
        }
        throw new RuntimeException(shutDownException);
    }

    @Override
    public URL getUrl() {
        return this.url;
    }
}

