/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.config;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.grid.config.Config;

public class CompoundConfig
implements Config {
    private final List<Config> allConfigs;

    public CompoundConfig(Config mostImportant, Config ... othersInDescendingOrderOfImportance) {
        this.allConfigs = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(mostImportant)).add(othersInDescendingOrderOfImportance)).build();
    }

    @Override
    public Optional<List<String>> getAll(String section, String option) {
        Objects.requireNonNull(section, "Section name not set");
        Objects.requireNonNull(option, "Option name not set");
        List values = this.allConfigs.stream().map(config -> config.getAll(section, option)).filter(Optional::isPresent).map(Optional::get).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
        return values.isEmpty() ? Optional.empty() : Optional.of(values);
    }
}

