/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.edge;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.service.DriverService;

public class EdgeDriverService
extends DriverService {
    public static final String EDGE_DRIVER_EXE_PROPERTY = "webdriver.edge.driver";
    public static final String EDGE_DRIVER_LOG_PROPERTY = "webdriver.edge.logfile";
    public static final String EDGE_DRIVER_VERBOSE_LOG_PROPERTY = "webdriver.edge.verboseLogging";

    public EdgeDriverService(File executable, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) throws IOException {
        super(executable, port, args, environment);
    }

    public static EdgeDriverService createDefaultService() {
        return (EdgeDriverService)new Builder().build();
    }

    public static class Builder
    extends DriverService.Builder<EdgeDriverService, Builder> {
        @Override
        public int score(Capabilities capabilities) {
            int score = 0;
            if ("MicrosoftEdge".equals(capabilities.getBrowserName())) {
                ++score;
            }
            return score;
        }

        @Override
        protected File findDefaultExecutable() {
            return EdgeDriverService.findExecutable("MicrosoftWebDriver", EdgeDriverService.EDGE_DRIVER_EXE_PROPERTY, "https://github.com/SeleniumHQ/selenium/wiki/MicrosoftWebDriver", "http://go.microsoft.com/fwlink/?LinkId=619687");
        }

        @Override
        protected ImmutableList<String> createArgs() {
            ImmutableList.Builder argsBuilder = ImmutableList.builder();
            argsBuilder.add(String.format("--port=%d", this.getPort()));
            if (Boolean.getBoolean(EdgeDriverService.EDGE_DRIVER_VERBOSE_LOG_PROPERTY)) {
                argsBuilder.add("--verbose");
            }
            return argsBuilder.build();
        }

        @Override
        protected EdgeDriverService createDriverService(File exe, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) {
            try {
                EdgeDriverService service = new EdgeDriverService(exe, port, args, environment);
                if (this.getLogFile() != null) {
                    service.sendOutputTo(new FileOutputStream(this.getLogFile()));
                } else {
                    String logFile = System.getProperty(EdgeDriverService.EDGE_DRIVER_LOG_PROPERTY);
                    if (logFile != null) {
                        service.sendOutputTo(new FileOutputStream(logFile));
                    }
                }
                return service;
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        }
    }
}

