/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.Runtime;
import org.openqa.selenium.json.JsonInput;

public class Log {
    private Log() {
    }

    public static Command<Void> clear() {
        return new Command<Void>("Log.clear", ImmutableMap.of());
    }

    public static Command<Void> enable() {
        return new Command<Void>("Log.enable", ImmutableMap.of());
    }

    public static Event<LogEntry> entryAdded() {
        return new Event<LogEntry>("Log.entryAdded", ConverterFunctions.map("entry", LogEntry.class));
    }

    public static class LogEntry {
        private final String source;
        private final String level;
        private final String text;
        private final Runtime.Timestamp timestamp;

        public LogEntry(String source, String level, String text, Runtime.Timestamp timestamp) {
            this.source = Objects.requireNonNull(source);
            this.level = Objects.requireNonNull(level);
            this.text = Objects.requireNonNull(text);
            this.timestamp = Objects.requireNonNull(timestamp);
        }

        public String getSource() {
            return this.source;
        }

        public String getLevel() {
            return this.level;
        }

        public String getText() {
            return this.text;
        }

        public Runtime.Timestamp getTimestamp() {
            return this.timestamp;
        }

        public org.openqa.selenium.logging.LogEntry asSeleniumLogEntry() {
            Level level;
            switch (this.getLevel()) {
                case "error": {
                    level = Level.SEVERE;
                    break;
                }
                case "verbose": {
                    level = Level.ALL;
                    break;
                }
                case "warning": {
                    level = Level.WARNING;
                    break;
                }
                default: {
                    level = Level.INFO;
                }
            }
            return new org.openqa.selenium.logging.LogEntry(level, this.getTimestamp().toMillis(), this.getText());
        }

        private Map<String, Object> toJson() {
            return ImmutableMap.of("source", this.getSource(), "level", this.getLevel(), "text", this.getText(), "timestamp", this.getTimestamp());
        }

        private static LogEntry fromJson(JsonInput input) {
            String source = null;
            String level = null;
            String text = null;
            Runtime.Timestamp timestamp = null;
            input.beginObject();
            block12: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "level": {
                        level = input.nextString();
                        continue block12;
                    }
                    case "source": {
                        source = input.nextString();
                        continue block12;
                    }
                    case "text": {
                        text = input.nextString();
                        continue block12;
                    }
                    case "timestamp": {
                        timestamp = (Runtime.Timestamp)input.read((Type)((Object)Runtime.Timestamp.class));
                        continue block12;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new LogEntry(source, level, text, timestamp);
        }
    }
}

