/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.remote.AbstractDriverOptions;

public class ChromeOptions
extends AbstractDriverOptions<ChromeOptions> {
    public static final String CAPABILITY = "goog:chromeOptions";
    private String binary;
    private List<String> args = new ArrayList<String>();
    private List<File> extensionFiles = new ArrayList<File>();
    private List<String> extensions = new ArrayList<String>();
    private Map<String, Object> experimentalOptions = new HashMap<String, Object>();

    public ChromeOptions() {
        this.setCapability("browserName", "chrome");
    }

    @Override
    public ChromeOptions merge(Capabilities extraCapabilities) {
        super.merge(extraCapabilities);
        return this;
    }

    public ChromeOptions setBinary(File path) {
        this.binary = Preconditions.checkNotNull(path).getPath();
        return this;
    }

    public ChromeOptions setBinary(String path) {
        this.binary = Preconditions.checkNotNull(path);
        return this;
    }

    public ChromeOptions addArguments(String ... arguments) {
        this.addArguments(ImmutableList.copyOf(arguments));
        return this;
    }

    public ChromeOptions addArguments(List<String> arguments) {
        this.args.addAll(arguments);
        return this;
    }

    public ChromeOptions addExtensions(File ... paths) {
        this.addExtensions(ImmutableList.copyOf(paths));
        return this;
    }

    public ChromeOptions addExtensions(List<File> paths) {
        for (File path : paths) {
            Preconditions.checkNotNull(path);
            Preconditions.checkArgument(path.exists(), "%s does not exist", (Object)path.getAbsolutePath());
            Preconditions.checkArgument(!path.isDirectory(), "%s is a directory", (Object)path.getAbsolutePath());
        }
        this.extensionFiles.addAll(paths);
        return this;
    }

    public ChromeOptions addEncodedExtensions(String ... encoded) {
        this.addEncodedExtensions(ImmutableList.copyOf(encoded));
        return this;
    }

    public ChromeOptions addEncodedExtensions(List<String> encoded) {
        for (String extension : encoded) {
            Preconditions.checkNotNull(extension);
        }
        this.extensions.addAll(encoded);
        return this;
    }

    public ChromeOptions setExperimentalOption(String name, Object value) {
        this.experimentalOptions.put(Preconditions.checkNotNull(name), value);
        return this;
    }

    public ChromeOptions setHeadless(boolean headless) {
        this.args.remove("--headless");
        if (headless) {
            this.args.add("--headless");
        }
        return this;
    }

    @Override
    protected int amendHashCode() {
        return Objects.hash(this.args, this.binary, this.experimentalOptions, this.extensionFiles, this.extensions);
    }

    @Override
    public Map<String, Object> asMap() {
        TreeMap toReturn = new TreeMap(super.asMap());
        TreeMap<String, Object> options = new TreeMap<String, Object>();
        this.experimentalOptions.forEach(options::put);
        if (this.binary != null) {
            options.put("binary", this.binary);
        }
        options.put("args", ImmutableList.copyOf(this.args));
        options.put("extensions", Stream.concat(this.extensionFiles.stream().map(file -> {
            try {
                return Base64.getEncoder().encodeToString(Files.toByteArray(file));
            }
            catch (IOException e) {
                throw new SessionNotCreatedException(e.getMessage(), e);
            }
        }), this.extensions.stream()).collect(ImmutableList.toImmutableList()));
        toReturn.put(CAPABILITY, options);
        return Collections.unmodifiableMap(toReturn);
    }
}

