/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDevToolsLocator;
import org.openqa.selenium.chrome.ChromeDriverCommandExecutor;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.devtools.Connection;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.html5.LocalStorage;
import org.openqa.selenium.html5.Location;
import org.openqa.selenium.html5.LocationContext;
import org.openqa.selenium.html5.SessionStorage;
import org.openqa.selenium.html5.WebStorage;
import org.openqa.selenium.interactions.HasTouchScreen;
import org.openqa.selenium.interactions.TouchScreen;
import org.openqa.selenium.mobile.NetworkConnection;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteTouchScreen;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.html5.RemoteLocationContext;
import org.openqa.selenium.remote.html5.RemoteWebStorage;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.mobile.RemoteNetworkConnection;

public class ChromeDriver
extends RemoteWebDriver
implements LocationContext,
WebStorage,
HasTouchScreen,
NetworkConnection {
    private final RemoteLocationContext locationContext = new RemoteLocationContext(this.getExecuteMethod());
    private final RemoteWebStorage webStorage = new RemoteWebStorage(this.getExecuteMethod());
    private final TouchScreen touchScreen = new RemoteTouchScreen(this.getExecuteMethod());
    private final RemoteNetworkConnection networkConnection = new RemoteNetworkConnection(this.getExecuteMethod());
    private final Optional<Connection> connection;

    public ChromeDriver() {
        this(ChromeDriverService.createDefaultService(), new ChromeOptions());
    }

    public ChromeDriver(ChromeDriverService service) {
        this(service, new ChromeOptions());
    }

    @Deprecated
    public ChromeDriver(Capabilities capabilities) {
        this(ChromeDriverService.createDefaultService(), capabilities);
    }

    public ChromeDriver(ChromeOptions options) {
        this(ChromeDriverService.createDefaultService(), options);
    }

    public ChromeDriver(ChromeDriverService service, ChromeOptions options) {
        this(service, (Capabilities)options);
    }

    @Deprecated
    public ChromeDriver(ChromeDriverService service, Capabilities capabilities) {
        super(new ChromeDriverCommandExecutor(service), capabilities);
        HttpClient.Factory factory = HttpClient.Factory.createDefault();
        this.connection = ChromeDevToolsLocator.getChromeConnector(factory, this.getCapabilities());
    }

    @Override
    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    @Override
    public LocalStorage getLocalStorage() {
        return this.webStorage.getLocalStorage();
    }

    @Override
    public SessionStorage getSessionStorage() {
        return this.webStorage.getSessionStorage();
    }

    @Override
    public Location location() {
        return this.locationContext.location();
    }

    @Override
    public void setLocation(Location location) {
        this.locationContext.setLocation(location);
    }

    @Override
    public TouchScreen getTouch() {
        return this.touchScreen;
    }

    @Override
    public NetworkConnection.ConnectionType getNetworkConnection() {
        return this.networkConnection.getNetworkConnection();
    }

    @Override
    public NetworkConnection.ConnectionType setNetworkConnection(NetworkConnection.ConnectionType type) {
        return this.networkConnection.setNetworkConnection(type);
    }

    public void launchApp(String id) {
        this.execute("launchApp", ImmutableMap.of("id", id));
    }

    public Map<String, Object> executeCdpCommand(String commandName, Map<String, Object> parameters) {
        Objects.requireNonNull(commandName, "Command name must be set.");
        Objects.requireNonNull(parameters, "Parameters for command must be set.");
        Map toReturn = (Map)this.getExecuteMethod().execute("executeCdpCommand", ImmutableMap.of("cmd", commandName, "params", parameters));
        return ImmutableMap.copyOf(toReturn);
    }

    public DevTools getDevTools() {
        return this.connection.map(DevTools::new).orElseThrow(() -> new WebDriverException("Unable to create DevTools connection"));
    }

    @Override
    public void quit() {
        this.connection.ifPresent(Connection::close);
        super.quit();
    }
}

