/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.Queues;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.index.qual.LessThanBottom;
import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.qual.LowerBoundBottom;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.SameLenBottom;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.qual.SearchIndexBottom;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.checker.index.qual.SubstringIndexBottom;
import org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.checker.index.qual.UpperBoundBottom;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.initialization.qual.FBCBottom;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.value.qual.UnknownVal;

@GwtIncompatible
final class ListenerCallQueue<@KeyForBottom L> {
    private static final @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Logger logger = Logger.getLogger(ListenerCallQueue.class.getName());
    private final @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown List<@UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown PerListenerQueue<L>> listeners = Collections.synchronizedList(new ArrayList());

    ListenerCallQueue() {
    }

    public void addListener(L listener, @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Executor executor) {
        Preconditions.checkNotNull(listener, "listener");
        Preconditions.checkNotNull(executor, "executor");
        this.listeners.add(new PerListenerQueue<L>(listener, executor));
    }

    public void enqueue(@KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Event<L> event) {
        this.enqueueHelper(event, event);
    }

    public void enqueue(@KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Event<L> event, @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom String label) {
        this.enqueueHelper(event, label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueHelper(@KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Event<L> event, @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Object label) {
        Preconditions.checkNotNull(event, "event");
        Preconditions.checkNotNull(label, "label");
        List<PerListenerQueue<L>> list = this.listeners;
        synchronized (list) {
            for (PerListenerQueue<L> queue : this.listeners) {
                queue.add(event, label);
            }
        }
    }

    public void dispatch() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).dispatch();
        }
    }

    private static final class PerListenerQueue<@KeyForBottom L>
    implements Runnable {
        final L listener;
        final @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Executor executor;
        @GuardedBy(value="this")
        final @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Queue<@UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Event<L>> waitQueue = Queues.newArrayDeque();
        @GuardedBy(value="this")
        final @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Queue<@UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Object> labelQueue = Queues.newArrayDeque();
        @GuardedBy(value="this")
        @UnknownKeyFor @NonNull @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown boolean isThreadScheduled;

        PerListenerQueue(L listener, @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Executor executor) {
            this.listener = Preconditions.checkNotNull(listener);
            this.executor = Preconditions.checkNotNull(executor);
        }

        synchronized void add(@KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Event<L> event, @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Object label) {
            this.waitQueue.add(event);
            this.labelQueue.add(label);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispatch() {
            boolean scheduleEventRunner = false;
            PerListenerQueue perListenerQueue = this;
            synchronized (perListenerQueue) {
                if (!this.isThreadScheduled) {
                    this.isThreadScheduled = true;
                    scheduleEventRunner = true;
                }
            }
            if (scheduleEventRunner) {
                try {
                    this.executor.execute(this);
                }
                catch (RuntimeException e) {
                    PerListenerQueue perListenerQueue2 = this;
                    synchronized (perListenerQueue2) {
                        this.isThreadScheduled = false;
                    }
                    logger.log(Level.SEVERE, "Exception while running callbacks for " + this.listener + " on " + this.executor, e);
                    throw e;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block18: {
                boolean stillRunning = true;
                block14: while (true) {
                    while (true) {
                        Object nextLabel;
                        Event<L> nextToRun;
                        PerListenerQueue perListenerQueue = this;
                        synchronized (perListenerQueue) {
                            Preconditions.checkState(this.isThreadScheduled);
                            nextToRun = this.waitQueue.poll();
                            nextLabel = this.labelQueue.poll();
                            if (nextToRun == null) {
                                this.isThreadScheduled = false;
                                stillRunning = false;
                                break block18;
                            }
                        }
                        try {
                            nextToRun.call(this.listener);
                            continue block14;
                        }
                        catch (RuntimeException e) {
                            logger.log(Level.SEVERE, "Exception while executing callback: " + this.listener + " " + nextLabel, e);
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    if (stillRunning) {
                        PerListenerQueue perListenerQueue = this;
                        synchronized (perListenerQueue) {
                            this.isThreadScheduled = false;
                        }
                    }
                }
            }
        }
    }

    static interface Event<@KeyForBottom L> {
        public void call(L var1);
    }
}

