/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ExecutionList;
import com.google.common.util.concurrent.ForwardingFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.checkerframework.checker.index.qual.LessThanBottom;
import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.qual.LowerBoundBottom;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.SameLenBottom;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.qual.SearchIndexBottom;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.checker.index.qual.SubstringIndexBottom;
import org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.checker.index.qual.UpperBoundBottom;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.initialization.qual.FBCBottom;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.value.qual.UnknownVal;

@Beta
@GwtIncompatible
public final class JdkFutureAdapters {
    public static <V> @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ListenableFuture<V> listenInPoolThread(@KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Future<V> future) {
        if (future instanceof ListenableFuture) {
            return (ListenableFuture)future;
        }
        return new ListenableFutureAdapter<V>(future);
    }

    public static <V> @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ListenableFuture<V> listenInPoolThread(@KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Future<V> future, @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Executor executor) {
        Preconditions.checkNotNull(executor);
        if (future instanceof ListenableFuture) {
            return (ListenableFuture)future;
        }
        return new ListenableFutureAdapter<V>(future, executor);
    }

    private JdkFutureAdapters() {
    }

    private static class ListenableFutureAdapter<@KeyForBottom V>
    extends ForwardingFuture<V>
    implements ListenableFuture<V> {
        private static final @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ListenableFutureAdapter-thread-%d").build();
        private static final @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Executor defaultAdapterExecutor = Executors.newCachedThreadPool(threadFactory);
        private final @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Executor adapterExecutor;
        private final @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ExecutionList executionList = new ExecutionList();
        private final @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown AtomicBoolean hasListeners = new AtomicBoolean(false);
        private final @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Future<V> delegate;

        ListenableFutureAdapter(@KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Future<V> delegate) {
            this(delegate, defaultAdapterExecutor);
        }

        ListenableFutureAdapter(@KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Future<V> delegate, @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Executor adapterExecutor) {
            this.delegate = Preconditions.checkNotNull(delegate);
            this.adapterExecutor = Preconditions.checkNotNull(adapterExecutor);
        }

        @Override
        protected @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Future<V> delegate() {
            return this.delegate;
        }

        @Override
        public void addListener(@KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Runnable listener, @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Executor exec) {
            this.executionList.add(listener, exec);
            if (this.hasListeners.compareAndSet(false, true)) {
                if (this.delegate.isDone()) {
                    this.executionList.execute();
                    return;
                }
                this.adapterExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Uninterruptibles.getUninterruptibly(delegate);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        executionList.execute();
                    }
                });
            }
        }
    }
}

