/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.math.LongMath;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.index.qual.IndexFor;
import org.checkerframework.checker.index.qual.LTLengthOf;
import org.checkerframework.checker.index.qual.LessThanBottom;
import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.qual.LowerBoundBottom;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.checker.index.qual.SameLenBottom;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.qual.SearchIndexBottom;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.checker.index.qual.SubstringIndexBottom;
import org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.checker.index.qual.UpperBoundBottom;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.initialization.qual.FBCBottom;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.value.qual.ArrayLenRange;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.MinLen;
import org.checkerframework.common.value.qual.UnknownVal;

@Beta
@GwtIncompatible
public final class Quantiles {
    public static @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ScaleAndIndex median() {
        return Quantiles.scale(2).index(1);
    }

    public static @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Scale quartiles() {
        return Quantiles.scale(4);
    }

    public static @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Scale percentiles() {
        return Quantiles.scale(100);
    }

    public static @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Scale scale(@KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @SearchIndexBottom @SameLenBottom @LessThanBottom @UpperBoundBottom @Positive int scale) {
        return new Scale(scale);
    }

    private static @UnknownKeyFor @NonNull @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown boolean containsNaN(double ... dataset) {
        for (double value : dataset) {
            if (!Double.isNaN(value)) continue;
            return true;
        }
        return false;
    }

    private static @UnknownKeyFor @NonNull @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown double interpolate(@KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom double lower, @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom double upper, @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom double remainder, @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom double scale) {
        if (lower == Double.NEGATIVE_INFINITY) {
            if (upper == Double.POSITIVE_INFINITY) {
                return Double.NaN;
            }
            return Double.NEGATIVE_INFINITY;
        }
        if (upper == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        return lower + (upper - lower) * remainder / scale;
    }

    private static void checkIndex(@KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom int index, @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom int scale) {
        if (index < 0 || index > scale) {
            throw new IllegalArgumentException("Quantile indexes must be between 0 and the scale, which is " + scale);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown double @UnknownKeyFor @Nullable @UnknownInitialization @ArrayLenRange(from=1, to=0x7FFFFFFF) @LessThanUnknown @MinLen(value=1) @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown [] longsToDoubles(@UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown long @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @ArrayLenRange(from=1, to=0x7FFFFFFF) @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @MinLen(value=1) [] longs) {
        int len = longs.length;
        double[] doubles = new double[len];
        for (int i = 0; i < len; ++i) {
            doubles[i] = longs[i];
        }
        return doubles;
    }

    private static @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown double @UnknownKeyFor @Nullable @UnknownInitialization @ArrayLenRange(from=1, to=0x7FFFFFFF) @LessThanUnknown @MinLen(value=1) @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown [] intsToDoubles(@UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown int @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @ArrayLenRange(from=1, to=0x7FFFFFFF) @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @MinLen(value=1) [] ints) {
        int len = ints.length;
        double[] doubles = new double[len];
        for (int i = 0; i < len; ++i) {
            doubles[i] = ints[i];
        }
        return doubles;
    }

    private static void selectInPlace(@KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @SearchIndexBottom @SameLenBottom @LessThanBottom @LTLengthOf(value={"#2"}) @IndexFor(value={"#2"}) @NonNegative int required, @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown double @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom [] array, @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @SearchIndexBottom @SameLenBottom @LessThanBottom @LTLengthOf(value={"#2"}) @IndexFor(value={"#2"}) @NonNegative int from, @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @SearchIndexBottom @SameLenBottom @LessThanBottom @LTLengthOf(value={"#2"}) @IndexFor(value={"#2"}) @NonNegative int to) {
        if (required == from) {
            int min = from;
            for (int index = from + 1; index <= to; ++index) {
                if (!(array[min] > array[index])) continue;
                min = index;
            }
            if (min != from) {
                Quantiles.swap(array, min, from);
            }
            return;
        }
        int fromInternal = from;
        while (to > fromInternal) {
            int partitionPoint = Quantiles.partition(array, fromInternal, to);
            if (partitionPoint >= required) {
                to = partitionPoint - 1;
            }
            if (partitionPoint > required) continue;
            fromInternal = partitionPoint + 1;
        }
    }

    private static @UnknownKeyFor @NonNull @UnknownInitialization @LessThanUnknown @LTLengthOf(value={"#1"}) @IndexFor(value={"#1"}) @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @NonNegative int partition(@UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown double @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom [] array, @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @SearchIndexBottom @SameLenBottom @LessThanBottom @LTLengthOf(value={"#1"}) @IndexFor(value={"#1"}) @NonNegative int from, @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @SearchIndexBottom @SameLenBottom @LessThanBottom @LTLengthOf(value={"#1"}) @IndexFor(value={"#1"}) @NonNegative int to) {
        Quantiles.movePivotToStartOfSlice(array, from, to);
        double pivot = array[from];
        int partitionPoint = to;
        for (int i = to; i > from; --i) {
            if (!(array[i] > pivot)) continue;
            Quantiles.swap(array, partitionPoint, i);
            --partitionPoint;
        }
        Quantiles.swap(array, from, partitionPoint);
        return partitionPoint;
    }

    private static void movePivotToStartOfSlice(@UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown double @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom [] array, @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @SearchIndexBottom @SameLenBottom @LessThanBottom @LTLengthOf(value={"#1"}) @IndexFor(value={"#1"}) @NonNegative int from, @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @SearchIndexBottom @SameLenBottom @LessThanBottom @LTLengthOf(value={"#1"}) @IndexFor(value={"#1"}) @NonNegative int to) {
        boolean toLessThanFrom;
        int mid = from + to >>> 1;
        boolean toLessThanMid = array[to] < array[mid];
        boolean midLessThanFrom = array[mid] < array[from];
        boolean bl = toLessThanFrom = array[to] < array[from];
        if (toLessThanMid == midLessThanFrom) {
            Quantiles.swap(array, mid, from);
        } else if (toLessThanMid != toLessThanFrom) {
            Quantiles.swap(array, from, to);
        }
    }

    private static void selectAllInPlace(@UnknownKeyFor @NonNull @Initialized @LessThanUnknown @LTLengthOf(value={"#4"}) @IndexFor(value={"#4"}) @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @NonNegative int @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom [] allRequired, @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @SearchIndexBottom @SameLenBottom @LessThanBottom @LTLengthOf(value={"#1"}) @IndexFor(value={"#1"}) @NonNegative int requiredFrom, @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @SearchIndexBottom @SameLenBottom @LessThanBottom @LTLengthOf(value={"#1"}) @IndexFor(value={"#1"}) @NonNegative int requiredTo, @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown double @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom [] array, @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @SearchIndexBottom @SameLenBottom @LessThanBottom @LTLengthOf(value={"#4"}) @IndexFor(value={"#4"}) @NonNegative int from, @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @SearchIndexBottom @SameLenBottom @LessThanBottom @LTLengthOf(value={"#4"}) @IndexFor(value={"#4"}) @NonNegative int to) {
        int requiredAbove;
        int requiredBelow;
        @IndexFor(value={"allRequired"}) int requiredChosen = Quantiles.chooseNextSelection(allRequired, requiredFrom, requiredTo, from, to);
        int required = allRequired[requiredChosen];
        Quantiles.selectInPlace(required, array, from, to);
        for (requiredBelow = requiredChosen - 1; requiredBelow >= requiredFrom && allRequired[requiredBelow] == required; --requiredBelow) {
        }
        if (requiredBelow >= requiredFrom) {
            Quantiles.selectAllInPlace(allRequired, requiredFrom, requiredBelow, array, from, required - 1);
        }
        for (requiredAbove = requiredChosen + 1; requiredAbove <= requiredTo && allRequired[requiredAbove] == required; ++requiredAbove) {
        }
        if (requiredAbove <= requiredTo) {
            Quantiles.selectAllInPlace(allRequired, requiredAbove, requiredTo, array, required + 1, to);
        }
    }

    private static @UnknownKeyFor @NonNull @UnknownInitialization @LessThanUnknown @LTLengthOf(value={"#1"}) @IndexFor(value={"#1"}) @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @NonNegative int chooseNextSelection(@UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown int @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom [] allRequired, @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @SearchIndexBottom @SameLenBottom @LessThanBottom @LTLengthOf(value={"#1"}) @IndexFor(value={"#1"}) @NonNegative int requiredFrom, @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @SearchIndexBottom @SameLenBottom @LessThanBottom @LTLengthOf(value={"#1"}) @IndexFor(value={"#1"}) @NonNegative int requiredTo, @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom int from, @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom int to) {
        if (requiredFrom == requiredTo) {
            return requiredFrom;
        }
        int centerFloor = from + to >>> 1;
        int low = requiredFrom;
        int high = requiredTo;
        while (high > low + 1) {
            int mid = low + high >>> 1;
            if (allRequired[mid] > centerFloor) {
                high = mid;
                continue;
            }
            if (allRequired[mid] < centerFloor) {
                low = mid;
                continue;
            }
            return mid;
        }
        if (from + to - allRequired[low] - allRequired[high] > 0) {
            return high;
        }
        return low;
    }

    private static void swap(@UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown double @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom [] array, @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @SearchIndexBottom @SameLenBottom @LessThanBottom @LTLengthOf(value={"#1"}) @IndexFor(value={"#1"}) @NonNegative int i, @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @SearchIndexBottom @SameLenBottom @LessThanBottom @LTLengthOf(value={"#1"}) @IndexFor(value={"#1"}) @NonNegative int j) {
        double temp = array[i];
        array[i] = array[j];
        array[j] = temp;
    }

    public static final class ScaleAndIndexes {
        private final @UnknownKeyFor @NonNull @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown int scale;
        private final @UnknownKeyFor @NonNull @Initialized @LessThanUnknown @NonNegative @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @UpperBoundUnknown int @UnknownKeyFor @Nullable @UnknownInitialization @ArrayLenRange(from=1, to=0x7FFFFFFF) @LessThanUnknown @MinLen(value=1) @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown [] indexes;

        private ScaleAndIndexes(@KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom int scale, @UnknownKeyFor @NonNull @Initialized @LessThanUnknown @NonNegative @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @UpperBoundUnknown int @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @ArrayLenRange(from=1, to=0x7FFFFFFF) @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @MinLen(value=1) [] indexes) {
            for (int index : indexes) {
                Quantiles.checkIndex(index, scale);
            }
            this.scale = scale;
            this.indexes = indexes;
        }

        public @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Map<@UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Integer, @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Double> compute(@KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Collection<@KeyForBottom @NonNull @Initialized @SubstringIndexBottom @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @BottomVal ? extends @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Number> dataset) {
            return this.computeInPlace(Doubles.toArray(dataset));
        }

        public @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Map<@UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Integer, @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Double> compute(double ... dataset) {
            return this.computeInPlace((double[])dataset.clone());
        }

        public @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Map<@UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Integer, @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Double> compute(long ... dataset) {
            return this.computeInPlace(Quantiles.longsToDoubles(dataset));
        }

        public @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Map<@UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Integer, @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Double> compute(int ... dataset) {
            return this.computeInPlace(Quantiles.intsToDoubles(dataset));
        }

        public @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Map<@UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Integer, @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Double> computeInPlace(double ... dataset) {
            Preconditions.checkArgument(dataset.length > 0, "Cannot calculate quantiles of an empty dataset");
            if (Quantiles.containsNaN(dataset)) {
                HashMap<Integer, Double> nanMap = new HashMap<Integer, Double>();
                for (int index : this.indexes) {
                    nanMap.put(index, Double.NaN);
                }
                return Collections.unmodifiableMap(nanMap);
            }
            @IndexFor(value={"dataset"}) int[] quotients = new int[this.indexes.length];
            int[] remainders = new int[this.indexes.length];
            int[] requiredSelections = new int[this.indexes.length * 2];
            int requiredSelectionsCount = 0;
            for (int i = 0; i < this.indexes.length; ++i) {
                long numerator = (long)this.indexes[i] * (long)(dataset.length - 1);
                int quotient = (int)LongMath.divide(numerator, this.scale, RoundingMode.DOWN);
                int remainder = (int)(numerator - (long)quotient * (long)this.scale);
                quotients[i] = quotient;
                remainders[i] = remainder;
                requiredSelections[requiredSelectionsCount] = quotient;
                ++requiredSelectionsCount;
                if (remainder == 0) continue;
                requiredSelections[requiredSelectionsCount] = quotient + 1;
                ++requiredSelectionsCount;
            }
            Arrays.sort(requiredSelections, 0, requiredSelectionsCount);
            Quantiles.selectAllInPlace(requiredSelections, 0, requiredSelectionsCount - 1, dataset, 0, dataset.length - 1);
            HashMap<Integer, Double> ret = new HashMap<Integer, Double>();
            for (int i = 0; i < this.indexes.length; ++i) {
                int quotient = quotients[i];
                int remainder = remainders[i];
                if (remainder == 0) {
                    ret.put(this.indexes[i], dataset[quotient]);
                    continue;
                }
                ret.put(this.indexes[i], Quantiles.interpolate(dataset[quotient], dataset[quotient + 1], remainder, this.scale));
            }
            return Collections.unmodifiableMap(ret);
        }
    }

    public static final class ScaleAndIndex {
        private final @UnknownKeyFor @NonNull @UnknownInitialization @LessThanUnknown @Positive @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @UpperBoundUnknown int scale;
        private final @UnknownKeyFor @NonNull @UnknownInitialization @LessThanUnknown @NonNegative @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @UpperBoundUnknown int index;

        private ScaleAndIndex(@KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @SearchIndexBottom @SameLenBottom @LessThanBottom @UpperBoundBottom @Positive int scale, @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @SearchIndexBottom @SameLenBottom @LessThanBottom @UpperBoundBottom @NonNegative int index) {
            Quantiles.checkIndex(index, scale);
            this.scale = scale;
            this.index = index;
        }

        public @UnknownKeyFor @NonNull @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown double compute(@KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Collection<@KeyForBottom @NonNull @Initialized @SubstringIndexBottom @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @BottomVal ? extends @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Number> dataset) {
            return this.computeInPlace(Doubles.toArray(dataset));
        }

        public @UnknownKeyFor @NonNull @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown double compute(double ... dataset) {
            return this.computeInPlace((double[])dataset.clone());
        }

        public @UnknownKeyFor @NonNull @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown double compute(long ... dataset) {
            return this.computeInPlace(Quantiles.longsToDoubles(dataset));
        }

        public @UnknownKeyFor @NonNull @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown double compute(int ... dataset) {
            return this.computeInPlace(Quantiles.intsToDoubles(dataset));
        }

        public @UnknownKeyFor @NonNull @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown double computeInPlace(double ... dataset) {
            Preconditions.checkArgument(dataset.length > 0, "Cannot calculate quantiles of an empty dataset");
            if (Quantiles.containsNaN(dataset)) {
                return Double.NaN;
            }
            @NonNegative long numerator = (long)this.index * (long)(dataset.length - 1);
            int quotient = (int)LongMath.divide(numerator, this.scale, RoundingMode.DOWN);
            int remainder = (int)(numerator - (long)quotient * (long)this.scale);
            Quantiles.selectInPlace(quotient, dataset, 0, dataset.length - 1);
            if (remainder == 0) {
                return dataset[quotient];
            }
            Quantiles.selectInPlace(quotient + 1, dataset, quotient + 1, dataset.length - 1);
            return Quantiles.interpolate(dataset[quotient], dataset[quotient + 1], remainder, this.scale);
        }
    }

    public static final class Scale {
        private final @UnknownKeyFor @NonNull @UnknownInitialization @LessThanUnknown @Positive @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @UpperBoundUnknown int scale;

        private Scale(@KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @SearchIndexBottom @SameLenBottom @LessThanBottom @UpperBoundBottom @Positive int scale) {
            Preconditions.checkArgument(scale > 0, "Quantile scale must be positive");
            this.scale = scale;
        }

        public @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ScaleAndIndex index(@KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @SearchIndexBottom @SameLenBottom @LessThanBottom @UpperBoundBottom @NonNegative int index) {
            return new ScaleAndIndex(this.scale, index);
        }

        public @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ScaleAndIndexes indexes(int ... indexes) {
            return new ScaleAndIndexes(this.scale, (int[])indexes.clone());
        }

        public @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ScaleAndIndexes indexes(@KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Collection<@UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Integer> indexes) {
            return new ScaleAndIndexes(this.scale, Ints.toArray(indexes));
        }
    }
}

