/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Ordering;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import org.checkerframework.checker.index.qual.LessThanBottom;
import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.qual.LowerBoundBottom;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.SameLenBottom;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.qual.SearchIndexBottom;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.checker.index.qual.SubstringIndexBottom;
import org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.checker.index.qual.UpperBoundBottom;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.initialization.qual.FBCBottom;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@GwtCompatible(serializable=true)
final class LexicographicalOrdering<@KeyForBottom T>
extends Ordering<Iterable<T>>
implements Serializable {
    final @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Comparator<@UnknownKeyFor @Nullable @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ? super T> elementOrder;
    private static final @UnknownKeyFor @NonNull @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown long serialVersionUID = 0L;

    LexicographicalOrdering(@KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Comparator<@UnknownKeyFor @Nullable @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ? super T> elementOrder) {
        this.elementOrder = elementOrder;
    }

    @Override
    public @UnknownKeyFor @NonNull @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown int compare(@KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Iterable<T> leftIterable, @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Iterable<T> rightIterable) {
        Iterator<T> left = leftIterable.iterator();
        Iterator<T> right = rightIterable.iterator();
        while (left.hasNext()) {
            if (!right.hasNext()) {
                return 1;
            }
            int result = this.elementOrder.compare(left.next(), right.next());
            if (result == 0) continue;
            return result;
        }
        if (right.hasNext()) {
            return -1;
        }
        return 0;
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown boolean equals(@Nullable @KeyForBottom @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof LexicographicalOrdering) {
            LexicographicalOrdering that = (LexicographicalOrdering)object;
            return this.elementOrder.equals(that.elementOrder);
        }
        return false;
    }

    @Pure
    public @UnknownKeyFor @NonNull @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown int hashCode() {
        return this.elementOrder.hashCode() ^ 0x7BB78CF5;
    }

    @SideEffectFree
    public @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown String toString() {
        return this.elementOrder + ".lexicographical()";
    }
}

