/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.AbstractMapBasedMultimap;
import com.google.common.collect.ListMultimap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.index.qual.LessThanBottom;
import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.qual.LowerBoundBottom;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.SameLenBottom;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.qual.SearchIndexBottom;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.checker.index.qual.SubstringIndexBottom;
import org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.checker.index.qual.UpperBoundBottom;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.dataflow.qual.Pure;

@GwtCompatible
abstract class AbstractListMultimap<@UnknownKeyFor K, @UnknownKeyFor V>
extends AbstractMapBasedMultimap<K, V>
implements ListMultimap<K, V> {
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown long serialVersionUID = 6588350623831699109L;

    protected AbstractListMultimap(@UnknownKeyFor @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Map<K, @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Collection<V>> map) {
        super(map);
    }

    @Override
    abstract @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown List<V> createCollection();

    @Override
    @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown List<V> createUnmodifiableEmptyCollection() {
        return Collections.emptyList();
    }

    @Override
    <E> @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Collection<E> unmodifiableCollectionSubclass(@UnknownKeyFor @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Collection<E> collection) {
        return Collections.unmodifiableList((List)collection);
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Collection<V> wrapCollection(K key, @UnknownKeyFor @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Collection<V> collection) {
        return this.wrapList(key, (List)collection, null);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown List<V> get(@Nullable K key) {
        return (List)super.get(key);
    }

    @Override
    @CanIgnoreReturnValue
    public @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown List<V> removeAll(@Nullable @UnknownKeyFor @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Object key) {
        return (List)super.removeAll(key);
    }

    @Override
    @CanIgnoreReturnValue
    public @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown List<V> replaceValues(@Nullable K key, @UnknownKeyFor @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Iterable<@KeyForBottom @NonNull @Initialized @SubstringIndexBottom @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @BottomVal ? extends V> values) {
        return (List)super.replaceValues(key, values);
    }

    @Override
    @CanIgnoreReturnValue
    public @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown boolean put(@Nullable K key, @Nullable V value) {
        return super.put(key, value);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Map<K, @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Collection<V>> asMap() {
        return super.asMap();
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown boolean equals(@Nullable @UnknownKeyFor @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Object object) {
        return super.equals(object);
    }
}

